import "./webextension-polyfill.js";
import { runClusterTabs } from "./clustertabs.js"

// Service Worker setup
self.addEventListener('install', (_event) => { self.skipWaiting(); });
self.addEventListener('activate', (event) => { event.waitUntil(self.clients.claim()); });


// Debounce function to prevent rapid consecutive executions
function debounce(func, wait) {
  let timeout;
  return function executedFunction(...args) {
    const later = () => {
      clearTimeout(timeout);
      func(...args);
    };
    clearTimeout(timeout);
    timeout = self.setTimeout(later, wait);
  };
}

// Debounced main function
const debouncedRunClusterTabs = debounce(runClusterTabs, 300);

// Listen for messages from the extension
self.addEventListener('message', (event) => {
  const cond = event.data && event.data.action === 'runClusterTabs'
  if (cond) { debouncedRunClusterTabs(); }
});

// Handle browser action clicks
browser.action.onClicked.addListener(() => { debouncedRunClusterTabs(); });

// Handle keyboard shortcuts
browser.commands.onCommand.addListener((command) => {
  if (command === "run-clustertabs") { debouncedRunClusterTabs(); }
});
