import { getAllTabs, reorganizeTabs } from "./tabs.js";
import { showNotification } from "./notification.js";
import { sendTabsToAPI, ClusterTabsError } from "./api.js"

async function redirectTo(url){ return browser.tabs.create({ url });}

// Main function to orchestrate the tab clustering process
async function runClusterTabs() {
  await browser.action.setIcon({ path: "clustertabs.gif" });
  const tabs = await getAllTabs();
  if (tabs.length <= 1) return;

  try {
    const tabGroups = await sendTabsToAPI(tabs);
    await reorganizeTabs(tabGroups, tabs);
    showNotification(
      `${tabs.length} tabs have been successfully reorganized into ${tabGroups.length} groups.`
    );
  }
  catch (error) {
    if (error instanceof ClusterTabsError) {
      showNotification(error.message);
      if (error.redirectUrl) { await redirectTo(error.redirectUrl) }
    } else {
      console.error("Unexpected error during tab processing:", error);
      showNotification("An unexpected error occurred while processing tabs. Please try again.");
    }
  }
  return await browser.action.setIcon({ path: "clustertabs.png" });
}

export { runClusterTabs }
